// Utilisation : du script :
//
//Sous Scilab, utiliser [y, Fs]=wavread(nom_fichier) pour récupérer les données.
//Sauvegarder les données avec save('DataAnalyse.mat', 'y') et save('FreqEch.mat', 'Fs').
//Enfin, lancer le script

// En cas de necessité, un fichier 'DataAnalyse.mat' et un fichier 'freqEch.mat' 
//sont présents dans l'archive pour vous permettre de tester l'analyse d'un /a/

//Récupération des données
load('DataAnalyse.mat', 'y')
load('FreqEch.mat', 'Fs')

T=[0:(1/Fs):(length(y)/Fs)-1/Fs]
Te = 1/Fs
Fe2 = Fs/2

//Paramétrage de la fft de base
M = length(y)
df = Fs/M
Frequence1 = df*[0:M-1]
x1 = fft(y)
x1(1)=0

Tst = x1
freqtst = Frequence1

/// Détermination des filtres
//Formant0
p0=15
fb0=100;
fh0=300;
f00=sqrt(fb0*fh0);
f=freqtst
G0=((%i*2*f00*f).^(p0/2)).*(((f00+%i*f).^(p0)).^(-1)); 
G0(1)=G0(2)

//Formant1
p1=100
fb1=500;
fh1=700;
f01=sqrt(fb1*fh1);
f=freqtst
G1=((%i*2*f01*f).^(p1/2)).*(((f01+%i*f).^(p1)).^(-1)); 
G1(1)=G1(2)

//Formant2
p2=75
fb2=900;
fh2=1100;
f02=sqrt(fb2*fh2);
f=freqtst
G2=((%i*2*f02*f).^(p2/2)).*(((f02+%i*f).^(p2)).^(-1)); 
G2(1)=G2(2)

//Filtrage du signal
Xformant0 = Tst.*G0
Xformant1 = Tst.*G1
Xformant2 = Tst.*G2

//Analyse des résultats
f0val = 0
f1val = 0
f2val = 0

for i=1:length(Xformant0)
    if abs(Xformant0(i))>5 then
        f0val=1
    end
end

for i=1:length(Xformant1)
    if abs(Xformant1(i))>5 then
        f1val=1
    end
end

for i=1:length(Xformant2)
    if abs(Xformant2(i))>5 then
        f2val=1
    end
end

if f2val == 1 then
    print(%io(2), ['Le signal correspond à un /a/'])
elseif f1val == 1 then
    print(%io(2), ['Le signal correspond à un /u/'])
elseif f0val == 1 then
    print(%io(2), ['Le signal correspond à un /i/'])
end
