clear all
close all
% Récupération du signal
load('SigTime.mat')
load('SigVal.mat')

% Paramètres du signal
% Temps d'échantillonnage
dT = SigTime(2)-SigTime(1)
% Temps total
Te = SigTime(end)-SigTime(1)
% Fenêtre de fréquence
Fe = 1/dT
% Pas fréquentiel
dF = 1/Te


% Normalisation du signal
maxval = abs(SigVal(1));
for i = 1:1:length(SigVal)
    if abs(SigVal(i))> maxval
        maxval = abs(SigVal(i));
    end
end

for i = 1:1:length(SigVal)
    SigVal(i) = SigVal(i)/maxval;
end

% Tracé du signal
figure(1)
plot(SigTime, SigVal)
grid
title('Signal original')
xlabel('Temps')
ylabel('Amplitude')

% Transformée rapide de fourier
G = fft(SigVal);
figure(2)
G = G(1:5512);
plot(abs(G))
title('FFT du signal original')
xlabel('Fréquence(Hz)')
ylabel('Amplitude')

% Fréquence à couper (normalisée en % de la fréquence max)
f0 = 500/(Fe/2)

% Calcul des coefficients du filtre Notch
% Paramètre 1 = Fréquence normalisée de coupure
% Paramètre 2 = Largeur de la bande coupée (normalisée)
[numfiltre1, denfiltre1] = iirnotch(f0, f0/5) 

% Filtrage
SigFil1 = filter(numfiltre1, denfiltre1, SigVal);

% Fenêtrage carré pour supprimer les bruits liés aux effets de bord
SigValFenetre = SigFil1(100:10000);
SigTimeFenetre = SigTime(100:10000);

% Tracé de la FFT pour vérifier les résultats
H = fft(SigValFenetre);
figure(3)
H = H(1:5512);
plot(abs(H))
xlabel('Fréquence(Hz)')
title('FFT du signal filtré')
ylabel('Amplitude')

% Ecriture du fichier de sortie
audiowrite('sortie.wav',SigValFenetre,floor(Fe))
