clear all
close all
% Récupération du signal
load('SigTime.mat')
load('SigVal.mat')

% Paramètres du signal
% Temps d'échantillonnage
Te = SigTime(2)-SigTime(1);
% Temps total
Ttot = SigTime(end)-SigTime(1);
% Fenêtre de fréquence
Fe = 1/Te;
% Pas fréquentiel
dF = 1/Ttot




% Normalisation du signal
maxval = abs(SigVal(1));
for i = 1:1:length(SigVal)
    if abs(SigVal(i))> maxval
        maxval = abs(SigVal(i));
    end
end

for i = 1:1:length(SigVal)
    SigVal(i) = SigVal(i)/maxval;
end

% Tracé du signal
figure(1)
plot(SigTime, SigVal)
title('Signal original')
xlabel('Temps')
ylabel('Amplitude')

% Transformée rapide de fourier
G = fft(SigVal);
figure(2)
plot(abs(G))
xlabel('Fréquence (Hz)')
ylabel('Amplitude')
title('FFT du signal original')

% Design du filtre
% Ordre souhaité. à augmenter jusqu'à obtenir l'atténuation souhaitée.
ordre = 20
% Fréquences remarquables
% Coupure basse
f0 = 490
w0 = 2*pi*f0
% Fond du puits. Doit être pile au milieu de f0 et f2.
f1 = 500
w1 = 2*pi*f1
% Coupure haute
f2 = 510
w2 = 2*pi*f2

% Filtres unitaires = polynômes en 1/z en puissances croissantes de 1/z
num0 = w0 ;
den0 = [1, -exp(-w0*Te)] ;

num1 = [1, exp(-w1*Te)] ;
den1 = w1 ;

num2 = [1, exp(-w1*Te)] ;
den2 = w1 ;

num3 = w2 ;
den3 = [1, -exp(-w2*Te)] ;

% Multiplication des num et den. Equivaut à une convolution sous matlab

numfiltreorig = conv(num3, conv(num2, conv(num1, num0)));
denfiltreorig = conv(den3, conv(den2, conv(den1, den0)));

numfiltre = numfiltreorig;
denfiltre = denfiltreorig;


for i = 1:1:(ordre-1)
    numfiltre = conv(numfiltre, numfiltreorig);
    denfiltre = conv(denfiltre, denfiltreorig);
end

% Filtrage : application des coefficients
SigFil = filter(numfiltre, denfiltre, SigVal);

% Tracé de bode
figure(3)
transfer0 = tf(numfiltre, denfiltre)
bode(transfer0)
title('Bode du filtre considéré')

% Pour ceux ou celles qui veulent entendre le massacre
% audiowrite('sortie.wav',SigFil,11025)
